<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('notifications')) {
            Schema::create('notifications', function (Blueprint $table) {
                $table->id();
                $table->string('title');
                $table->text('message');
                $table->enum('notification_type', ['general', 'course', 'update', 'payment'])->default('general');
                $table->enum('target_audience', ['all', 'specific_users', 'category_users'])->default('all');
                $table->unsignedBigInteger('target_category_id')->nullable();
                $table->string('image_url')->nullable();
                $table->string('link_url')->nullable();
                $table->boolean('is_sent')->default(false);
                $table->dateTime('sent_at')->nullable();
                $table->unsignedBigInteger('created_by');
                $table->timestamps();

                $table->foreign('created_by')->references('id')->on('admins')->onDelete('cascade');
                $table->foreign('target_category_id')->references('id')->on('categories')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
