<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('leitner_cards')) {
            Schema::create('leitner_cards', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id');
                $table->unsignedBigInteger('flashcard_id');
                $table->unsignedInteger('box_number')->default(1);
                $table->dateTime('next_review')->nullable();
                $table->dateTime('last_reviewed')->nullable();
                $table->timestamps();

                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('flashcard_id')->references('id')->on('flashcards')->onDelete('cascade');
                $table->unique(['user_id', 'flashcard_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leitner_cards');
    }
};
