<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {
                $table->id();
                $table->string('user_id')->unique();
                $table->string('phone_number')->unique();
                $table->string('name')->nullable();
                $table->string('email')->nullable();
                $table->string('profile_image')->nullable();
                $table->unsignedInteger('score')->default(0);
                $table->unsignedInteger('rank')->default(0);
                $table->boolean('is_active')->default(true);
                $table->boolean('is_blocked')->default(false);
                $table->timestamp('last_login')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
