<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('flashcards')) {
            Schema::create('flashcards', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('category_id');
                $table->text('question');
                $table->text('answer');
                $table->enum('difficulty', ['easy', 'medium', 'hard'])->default('medium');
                $table->text('hint')->nullable();
                $table->string('tags')->nullable();
                $table->boolean('is_approved')->default(false);
                $table->unsignedBigInteger('approved_by')->nullable();
                $table->boolean('is_active')->default(true);
                $table->unsignedInteger('views_count')->default(0);
                $table->timestamps();

                $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
                $table->foreign('approved_by')->references('id')->on('admins')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('flashcards');
    }
};
