<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('books')) {
            Schema::create('books', function (Blueprint $table) {
                $table->id();
                $table->string('title');
                $table->string('author');
                $table->string('publisher')->nullable();
                $table->string('isbn')->nullable();
                $table->text('description')->nullable();
                $table->unsignedBigInteger('category_id');
                $table->unsignedInteger('price')->default(0);
                $table->unsignedInteger('total_pages')->default(0);
                $table->string('cover_image')->nullable();
                $table->string('pdf_file')->nullable();
                $table->string('encrypted_path')->nullable();
                $table->unsignedInteger('downloads_count')->default(0);
                $table->unsignedInteger('views_count')->default(0);
                $table->unsignedBigInteger('created_by');
                $table->boolean('is_active')->default(true);
                $table->timestamps();

                $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
                $table->foreign('created_by')->references('id')->on('admins')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('books');
    }
};
