<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('user_book_progress')) {
            Schema::create('user_book_progress', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id');
                $table->unsignedBigInteger('book_id');
                $table->string('cfi')->nullable();
                $table->integer('current_page')->nullable();
                $table->decimal('percentage', 5, 2)->default(0);
                $table->timestamp('last_read_at')->nullable();
                $table->timestamps();

                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('book_id')->references('id')->on('books')->onDelete('cascade');

                $table->unique(['user_id', 'book_id']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('user_book_progress');
    }
};
