<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت کاربران';
$db = Database::getInstance();

// دریافت همه کاربران (DataTable خودش pagination و search را انجام می‌دهد)
$sql = "
    SELECT
        u.*,
        s.plan_type,
        s.current_period_end,
        COUNT(DISTINCT c.id) as cycles_count
    FROM users u
    LEFT JOIN subscriptions s ON u.id = s.user_id AND s.status = 'active'
    LEFT JOIN cycles c ON u.id = c.user_id
    GROUP BY u.id
    ORDER BY u.created_at DESC
";

$users = $db->query($sql)->fetchAll();
$total = count($users);

// اضافه کردن CSS برای DataTable
$extraCSS = '<link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap.min.css" rel="stylesheet">';

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>
                    لیست کاربران
                    <small><?php echo number_format($total); ?> کاربر</small>
                </h2>
                <ul class="header-dropdown m-r--5">
                    <li>
                        <a href="user_create.php" class="btn-action btn-save waves-effect">
                            <i class="material-icons">add</i>
                            <span>افزودن کاربر جدید</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="body">
                <!-- جدول کاربران -->
                <div class="table-responsive">
                    <table id="usersTable" class="table table-bordered table-striped table-hover dataTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>ایمیل</th>
                                <th>نام کاربری</th>
                                <th>نقش کاربر</th>
                                <th>جنسیت</th>
                                <th>سن</th>
                                <th>پلن</th>
                                <th>چرخه‌ها</th>
                                <th>وضعیت</th>
                                <th>تاریخ عضویت</th>
                                <th>آخرین آنلاین</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?php echo $user['id']; ?></td>
                                <td><?php echo h($user['email']); ?></td>
                                <td><?php echo h($user['username'] ?? '-'); ?></td>
                                <td>
                                    <?php
                                    $role = $user['user_role'] ?? 'user';
                                    $roleLabels = [
                                        'user' => 'کاربر عادی',
                                        'moderator' => 'مدیر',
                                        'contributor' => 'همکار',
                                        'vip' => 'VIP'
                                    ];
                                    echo h($roleLabels[$role] ?? $role);
                                    ?>
                                </td>
                                <td><?php echo getGenderLabel($user['gender']); ?></td>
                                <td><?php echo $user['age'] ?? '-'; ?></td>
                                <td><?php echo $user['plan_type'] ? getPlanBadge($user['plan_type']) : '-'; ?></td>
                                <td><?php echo number_format($user['cycles_count']); ?></td>
                                <td><?php echo getUserStatusBadge($user['status']); ?></td>
                                <td><?php echo formatDate($user['created_at'], 'Y/m/d'); ?></td>
                                <td><?php echo $user['last_online'] ? timeAgo($user['last_online']) : '-'; ?></td>
                                <td class="table-actions">
                                    <a href="user_detail.php?id=<?php echo $user['id']; ?>" class="btn btn-xs btn-info" title="مشاهده جزئیات">
                                        <i class="material-icons">visibility</i>
                                    </a>

                                    <?php if ($user['status'] === 'banned'): ?>
                                    <a href="api/user_unban.php?id=<?php echo $user['id']; ?>" class="btn btn-xs btn-success btn-unban" title="رفع مسدودیت">
                                        <i class="material-icons">check</i>
                                    </a>
                                    <?php else: ?>
                                    <a href="user_ban.php?id=<?php echo $user['id']; ?>" class="btn btn-xs btn-warning" title="مسدود کردن">
                                        <i class="material-icons">block</i>
                                    </a>
                                    <?php endif; ?>

                                    <a href="api/user_delete.php?id=<?php echo $user['id']; ?>" class="btn btn-xs btn-danger btn-delete" title="حذف">
                                        <i class="material-icons">delete</i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($users)): ?>
                            <tr>
                                <td colspan="12" class="text-center">کاربری یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// اضافه کردن JS برای DataTable
$extraJS = '
<!-- jQuery DataTable JS -->
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap.min.js"></script>

<script>
$(document).ready(function() {
    if ($.fn.DataTable) {
        $("#usersTable").DataTable({
            "language": {
                "search": "جستجو:",
                "lengthMenu": "نمایش _MENU_ رکورد",
                "info": "نمایش _START_ تا _END_ از _TOTAL_ رکورد",
                "infoEmpty": "هیچ رکوردی یافت نشد",
                "infoFiltered": "(فیلتر شده از _MAX_ رکورد)",
                "paginate": {
                    "first": "اول",
                    "last": "آخر",
                    "next": "بعدی",
                    "previous": "قبلی"
                },
                "emptyTable": "هیچ داده‌ای در جدول وجود ندارد",
                "zeroRecords": "هیچ رکورد مطابقی یافت نشد"
            },
            "pageLength": 25,
            "order": [[0, "desc"]],
            "columnDefs": [
                { "orderable": false, "targets": [11] }
            ],
            "responsive": true,
            "autoWidth": false
        });
    }

    // تایید حذف کاربر
    $(".btn-delete").on("click", function(e) {
        e.preventDefault();

        if (confirm("آیا از حذف این کاربر اطمینان دارید؟\\nاین عمل قابل بازگشت نیست.")) {
            window.location.href = $(this).attr("href");
        }
    });
});
</script>
';

include 'php/includes/footer.php';
?>
