<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'ویرایش کاربر';
$db = Database::getInstance();
$session = Session::getInstance();

$userId = (int)get('id', 0);

if (!$userId) {
    redirect('users.php');
}

// دریافت اطلاعات کاربر
$user = $db->fetchOne("SELECT * FROM users WHERE id = ?", [$userId]);

if (!$user) {
    redirect('users.php');
}

$errors = [];
$formData = $user;

if (isPost()) {
    // دریافت داده‌های فرم
    $formData = [
        'email' => sanitize(post('email')),
        'username' => sanitize(post('username')),
        'full_name' => sanitize(post('full_name')),
        'user_role' => post('user_role', 'user'),
        'gender' => post('gender'),
        'age' => (int)post('age', 0),
        'birth_date' => post('birth_date'),
        'language' => post('language', 'fa'),
        'calendar_type' => post('calendar_type', 'gregorian'),
        'timezone' => post('timezone'),
        'status' => post('status')
    ];

    // اعتبارسنجی
    if (empty($formData['email'])) {
        $errors[] = 'ایمیل الزامی است.';
    } elseif (!isValidEmail($formData['email'])) {
        $errors[] = 'فرمت ایمیل نامعتبر است.';
    } else {
        // بررسی تکراری نبودن ایمیل
        $existingUser = $db->fetchOne("SELECT id FROM users WHERE email = ? AND id != ?", [$formData['email'], $userId]);
        if ($existingUser) {
            $errors[] = 'این ایمیل قبلاً ثبت شده است.';
        }
    }

    if ($formData['username']) {
        // بررسی تکراری نبودن نام کاربری
        $existingUsername = $db->fetchOne("SELECT id FROM users WHERE username = ? AND id != ?", [$formData['username'], $userId]);
        if ($existingUsername) {
            $errors[] = 'این نام کاربری قبلاً استفاده شده است.';
        }
    }

    // بررسی تغییر رمز عبور
    if (post('password')) {
        if (strlen(post('password')) < 8) {
            $errors[] = 'رمز عبور باید حداقل 8 کاراکتر باشد.';
        } elseif (post('password') !== post('password_confirm')) {
            $errors[] = 'تکرار رمز عبور مطابقت ندارد.';
        } else {
            $formData['password_hash'] = hashPassword(post('password'));
        }
    }

    if (empty($errors)) {
        try {
            // بروزرسانی کاربر
            $updateData = [
                'email' => $formData['email'],
                'username' => $formData['username'] ?: null,
                'full_name' => $formData['full_name'] ?: null,
                'user_role' => $formData['user_role'],
                'gender' => $formData['gender'] ?: null,
                'age' => $formData['age'] ?: null,
                'birth_date' => $formData['birth_date'] ?: null,
                'language' => $formData['language'],
                'calendar_type' => $formData['calendar_type'],
                'timezone' => $formData['timezone'] ?: null,
                'status' => $formData['status'],
                'updated_at' => date('Y-m-d H:i:s')
            ];

            if (isset($formData['password_hash'])) {
                $updateData['password_hash'] = $formData['password_hash'];
            }

            $db->update('users', $updateData, 'id = ?', [$userId]);

            $session->setSuccess('اطلاعات کاربر با موفقیت بروزرسانی شد.');
            redirect('user_detail.php?id=' . $userId);

        } catch (Exception $e) {
            $errors[] = 'خطا در بروزرسانی کاربر: ' . $e->getMessage();
            logError('Error updating user: ' . $e->getMessage());
        }
    }
}

include 'php/includes/header.php';
?>


<div class="row clearfix">
    <div class="col-lg-8 col-md-10 col-sm-12 col-xs-12" style="margin: 0 auto; float: none;">
        <div class="card">
            <div class="header">
                <h2>
                    ویرایش اطلاعات کاربر #<?php echo $userId; ?>
                    <small><?php echo h($user['email']); ?></small>
                </h2>
            </div>
            <div class="body">
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <strong>خطاها:</strong>
                        <ul class="m-b-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?php echo h($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">

                    <h4 class="m-t-0">اطلاعات اولیه</h4>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>ایمیل <span class="text-danger">*</span></label>
                                <div class="form-line">
                                    <input type="email" name="email" class="form-control" required
                                           value="<?php echo h($formData['email']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نام کاربری</label>
                                <div class="form-line">
                                    <input type="text" name="username" class="form-control"
                                           value="<?php echo h($formData['username'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="alert alert-info">
                        <i class="material-icons">info</i>
                        اگر می‌خواهید رمز عبور را تغییر دهید، فیلدهای زیر را پر کنید. در غیر این صورت خالی بگذارید.
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رمز عبور جدید</label>
                                <div class="form-line">
                                    <input type="password" name="password" class="form-control"
                                           minlength="8" placeholder="حداقل 8 کاراکتر">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تکرار رمز عبور جدید</label>
                                <div class="form-line">
                                    <input type="password" name="password_confirm" class="form-control"
                                           minlength="8">
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>
                    <h4>اطلاعات شخصی</h4>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نام کامل</label>
                                <div class="form-line">
                                    <input type="text" name="full_name" class="form-control"
                                           value="<?php echo h($formData['full_name'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نقش کاربر</label>
                                <select name="user_role" class="form-control">
                                    <option value="user" <?php echo ($formData['user_role'] ?? 'user') === 'user' ? 'selected' : ''; ?>>کاربر عادی</option>
                                    <option value="moderator" <?php echo ($formData['user_role'] ?? 'user') === 'moderator' ? 'selected' : ''; ?>>مدیر</option>
                                    <option value="contributor" <?php echo ($formData['user_role'] ?? 'user') === 'contributor' ? 'selected' : ''; ?>>همکار</option>
                                    <option value="vip" <?php echo ($formData['user_role'] ?? 'user') === 'vip' ? 'selected' : ''; ?>>VIP</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>جنسیت</label>
                                <select name="gender" class="form-control">
                                    <option value="">انتخاب کنید</option>
                                    <option value="male" <?php echo ($formData['gender'] ?? '') === 'male' ? 'selected' : ''; ?>>مرد</option>
                                    <option value="female" <?php echo ($formData['gender'] ?? '') === 'female' ? 'selected' : ''; ?>>زن</option>
                                    <option value="other" <?php echo ($formData['gender'] ?? '') === 'other' ? 'selected' : ''; ?>>سایر</option>
                                    <option value="prefer_not_to_say" <?php echo ($formData['gender'] ?? '') === 'prefer_not_to_say' ? 'selected' : ''; ?>>ترجیح می‌دهم نگویم</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>سن</label>
                                <div class="form-line">
                                    <input type="number" name="age" class="form-control" min="1" max="150"
                                           value="<?php echo h($formData['age'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>تاریخ تولد</label>
                                <div class="form-line">
                                    <input type="date" name="birth_date" class="form-control"
                                           value="<?php echo h($formData['birth_date'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>
                    <h4>تنظیمات</h4>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>زبان</label>
                                <select name="language" class="form-control">
                                    <option value="fa" <?php echo ($formData['language'] ?? 'fa') === 'fa' ? 'selected' : ''; ?>>فارسی</option>
                                    <option value="en" <?php echo ($formData['language'] ?? 'fa') === 'en' ? 'selected' : ''; ?>>English</option>
                                    <option value="de" <?php echo ($formData['language'] ?? 'fa') === 'de' ? 'selected' : ''; ?>>Deutsch</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>نوع تقویم</label>
                                <select name="calendar_type" class="form-control">
                                    <option value="gregorian" <?php echo ($formData['calendar_type'] ?? 'gregorian') === 'gregorian' ? 'selected' : ''; ?>>میلادی</option>
                                    <option value="jalali" <?php echo ($formData['calendar_type'] ?? 'gregorian') === 'jalali' ? 'selected' : ''; ?>>شمسی</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>وضعیت حساب</label>
                                <select name="status" class="form-control">
                                    <option value="active" <?php echo ($formData['status'] ?? 'active') === 'active' ? 'selected' : ''; ?>>فعال</option>
                                    <option value="suspended" <?php echo ($formData['status'] ?? 'active') === 'suspended' ? 'selected' : ''; ?>>معلق</option>
                                    <option value="banned" <?php echo ($formData['status'] ?? 'active') === 'banned' ? 'selected' : ''; ?>>مسدود</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>منطقه زمانی</label>
                                <div class="form-line">
                                    <input type="text" name="timezone" class="form-control"
                                           value="<?php echo h($formData['timezone'] ?? ''); ?>"
                                           placeholder="مثلاً: Asia/Tehran">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="alert alert-warning">
                        <i class="material-icons">warning</i>
                        <strong>نکته:</strong> تغییر وضعیت به "مسدود" کاربر را از ورود به سیستم منع می‌کند.
                        برای مسدود کردن با دلیل و پیام، از صفحه جزئیات کاربر استفاده کنید.
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn-action btn-save waves-effect">
                                <i class="material-icons">save</i>
                                <span>ذخیره تغییرات</span>
                            </button>

                            <a href="user_detail.php?id=<?php echo $userId; ?>" class="btn-action waves-effect">
                                <i class="material-icons">cancel</i>
                                <span>انصراف</span>
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
