<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت اعلان‌ها';
$db = Database::getInstance();

// دریافت فیلترها
$status = get('status', '');
$page = max(1, (int)get('page', 1));

$total = 0;
$notifications = [];
$pagination = paginate(0, $page);

try {
    // ساخت Query
    $where = [];
    $params = [];

    if ($status) {
        $where[] = "n.status = ?";
        $params[] = $status;
    }

    $whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

    // شمارش کل
    $total = $db->fetchColumn("SELECT COUNT(*) FROM notifications n {$whereClause}", $params);

    // Pagination
    $pagination = paginate($total, $page);

    // دریافت اعلان‌ها
    $sql = "
        SELECT
            n.*,
            u.full_name as admin_name
        FROM notifications n
        LEFT JOIN users u ON n.sent_by = u.id
        {$whereClause}
        ORDER BY n.created_at DESC
        LIMIT {$pagination['per_page']} OFFSET {$pagination['offset']}
    ";

    $notifications = $db->fetchAll($sql, $params);
} catch (Exception $e) {
    // اگر جدول notifications وجود ندارد، خطا را نادیده بگیر
}

include 'php/includes/header.php';
?>


<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <h2>
                    لیست اعلان‌ها
                    <small><?php echo number_format($total); ?> اعلان</small>
                </h2>
                <ul class="header-dropdown m-r--5">
                    <li>
                        <a href="notification_create.php" class="btn-action btn-save waves-effect">
                            <i class="material-icons">add</i>
                            <span>ایجاد اعلان جدید</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="body">
                <!-- فیلترها -->
                <form method="GET" action="" class="form-inline m-b-20">
                    <div class="form-group">
                        <select name="status" class="form-control">
                            <option value="">همه وضعیت‌ها</option>
                            <option value="pending" <?php echo $status === 'pending' ? 'selected' : ''; ?>>در انتظار</option>
                            <option value="scheduled" <?php echo $status === 'scheduled' ? 'selected' : ''; ?>>زمان‌بندی شده</option>
                            <option value="sending" <?php echo $status === 'sending' ? 'selected' : ''; ?>>در حال ارسال</option>
                            <option value="sent" <?php echo $status === 'sent' ? 'selected' : ''; ?>>ارسال شده</option>
                            <option value="failed" <?php echo $status === 'failed' ? 'selected' : ''; ?>>خطا</option>
                        </select>
                    </div>

                    <button type="submit" class="btn-action waves-effect">
                        <i class="material-icons">search</i>
                        <span>فیلتر</span>
                    </button>

                    <a href="notifications.php" class="btn-action waves-effect">
                        <i class="material-icons">clear</i>
                        <span>پاک کردن</span>
                    </a>
                </form>

                <!-- جدول اعلان‌ها -->
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>عنوان</th>
                                <th>نوع</th>
                                <th>وضعیت</th>
                                <th>زمان ارسال</th>
                                <th>ارسال شده / کل</th>
                                <th>نرخ کلیک</th>
                                <th>ایجادکننده</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($notifications as $notification): ?>
                            <tr>
                                <td><?php echo $notification['id']; ?></td>
                                <td>
                                    <strong><?php echo h($notification['title']); ?></strong>
                                    <br>
                                    <small class="text-muted"><?php echo truncate($notification['body'], 50); ?></small>
                                </td>
                                <td>
                                    <?php
                                    $typeLabels = [
                                        'single' => '<span class="badge bg-blue">تک نفره</span>',
                                        'group' => '<span class="badge bg-orange">گروهی</span>',
                                        'all' => '<span class="badge bg-purple">همگانی</span>'
                                    ];
                                    echo $typeLabels[$notification['type']] ?? $notification['type'];
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $statusLabels = [
                                        'pending' => '<span class="badge bg-grey">در انتظار</span>',
                                        'scheduled' => '<span class="badge bg-blue">زمان‌بندی شده</span>',
                                        'sending' => '<span class="badge bg-orange">در حال ارسال</span>',
                                        'sent' => '<span class="badge bg-green">ارسال شده</span>',
                                        'failed' => '<span class="badge bg-red">خطا</span>'
                                    ];
                                    echo $statusLabels[$notification['status']] ?? $notification['status'];
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    if ($notification['scheduled_at']) {
                                        echo formatDate($notification['scheduled_at']);
                                    } else {
                                        echo formatDate($notification['sent_at'] ?? $notification['created_at']);
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $total_count = $notification['sent_count'] ?? 0;
                                    $target_count = $notification['target_count'] ?? 0;
                                    $percentage = $target_count > 0 ? round(($total_count / $target_count) * 100) : 0;
                                    echo number_format($total_count) . ' / ' . number_format($target_count);
                                    echo ' <small>(' . $percentage . '%)</small>';
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $sent = $notification['sent_count'] ?? 0;
                                    $clicked = $notification['clicked_count'] ?? 0;
                                    $clickRate = $sent > 0 ? round(($clicked / $sent) * 100, 1) : 0;
                                    echo $clickRate . '%';
                                    ?>
                                </td>
                                <td><?php echo h($notification['admin_name'] ?? 'سیستم'); ?></td>
                                <td class="table-actions">
                                    <a href="notification_detail.php?id=<?php echo $notification['id']; ?>" class="btn btn-xs btn-info" title="مشاهده جزئیات">
                                        <i class="material-icons">visibility</i>
                                    </a>

                                    <?php if ($notification['status'] === 'pending' || $notification['status'] === 'scheduled'): ?>
                                    <button class="btn btn-xs btn-danger" onclick="confirmCancel(<?php echo $notification['id']; ?>)" title="لغو">
                                        <i class="material-icons">cancel</i>
                                    </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($notifications)): ?>
                            <tr>
                                <td colspan="9" class="text-center">اعلانی یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                <ul class="pagination">
                    <?php if ($pagination['has_prev']): ?>
                    <li><a href="?page=<?php echo $page - 1; ?>&status=<?php echo $status; ?>">قبلی</a></li>
                    <?php endif; ?>

                    <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                    <li class="<?php echo $i === $page ? 'active' : ''; ?>">
                        <a href="?page=<?php echo $i; ?>&status=<?php echo $status; ?>"><?php echo $i; ?></a>
                    </li>
                    <?php endfor; ?>

                    <?php if ($pagination['has_next']): ?>
                    <li><a href="?page=<?php echo $page + 1; ?>&status=<?php echo $status; ?>">بعدی</a></li>
                    <?php endif; ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function confirmCancel(id) {
    if (confirm('آیا از لغو این اعلان اطمینان دارید؟')) {
        window.location.href = '../api/notification_cancel.php?id=' + id;
    }
}
</script>

<?php include 'php/includes/footer.php'; ?>
