<?php
// جلوگیری از اجرای middleware
define('AYENEH_ADMIN', true);

// بارگذاری مستقیم بدون autoload
require_once 'php/config.php';
require_once PHP_PATH . 'db.class.php';
require_once PHP_PATH . 'session.class.php';
require_once PHP_PATH . 'auth.class.php';

// بارگذاری توابع کمکی
if (file_exists(INCLUDES_PATH . 'functions.php')) {
    require_once INCLUDES_PATH . 'functions.php';
} else {
    require_once PHP_PATH . 'helper.functions.php';
}

// logout کاربر
$auth = Auth::getInstance();
$session = Session::getInstance();

// استفاده از متد logout که session و cookie را پاک می‌کند
$auth->logout();

// اطمینان از پاک شدن کامل session
$session->clear();
$session->destroy();

// حذف همه کوکی‌ها
if (isset($_COOKIE['remember_me'])) {
    setcookie('remember_me', '', time() - 3600, '/', '', false, true);
    unset($_COOKIE['remember_me']);
}

// Cache control headers برای جلوگیری از بازگشت به صفحات قبلی
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');

// هدایت به صفحه لاگین
header('Location: login.php');
exit;
