<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت AI';
$db = Database::getInstance();

// آمار AI
$stats = [
    'opt_in_users' => $db->count('users', 'ai_opt_in = 1'),
    'deletion_requests' => $db->count('ai_deletion_requests', 'status = ?', ['pending']),
    'completed_deletions' => $db->count('ai_deletion_requests', 'status = ?', ['completed']),
    'total_analyses' => $db->count('ai_analyses')
];

// کاربران Opt-in
$opt_in_users = $db->query("
    SELECT id, email, full_name, ai_opt_in_date
    FROM users
    WHERE ai_opt_in = 1
    ORDER BY ai_opt_in_date DESC
    LIMIT 50
")->fetchAll();

// درخواست‌های حذف
$deletion_requests = $db->query("
    SELECT
        dr.*,
        u.email,
        u.full_name
    FROM ai_deletion_requests dr
    LEFT JOIN users u ON dr.user_id = u.id
    ORDER BY dr.created_at DESC
    LIMIT 50
")->fetchAll();

include 'php/includes/header.php';
?>

<!-- آمار کلی -->
<div class="row clearfix">
    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-cyan hover-expand-effect">
            <div class="icon">
                <i class="material-icons">psychology</i>
            </div>
            <div class="content">
                <div class="text">کاربران Opt-in</div>
                <div class="number"><?php echo number_format($stats['opt_in_users']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-orange hover-expand-effect">
            <div class="icon">
                <i class="material-icons">delete_sweep</i>
            </div>
            <div class="content">
                <div class="text">درخواست‌های حذف</div>
                <div class="number"><?php echo number_format($stats['deletion_requests']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-green hover-expand-effect">
            <div class="icon">
                <i class="material-icons">check_circle</i>
            </div>
            <div class="content">
                <div class="text">حذف‌های انجام شده</div>
                <div class="number"><?php echo number_format($stats['completed_deletions']); ?></div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box-3 bg-purple hover-expand-effect">
            <div class="icon">
                <i class="material-icons">analytics</i>
            </div>
            <div class="content">
                <div class="text">تحلیل‌های انجام شده</div>
                <div class="number"><?php echo number_format($stats['total_analyses']); ?></div>
            </div>
        </div>
    </div>
</div>

<div class="row clearfix">
    <!-- کاربران Opt-in -->
    <div class="col-lg-6">
        <div class="card">
            <div class="header">
                <h2>کاربران فعال در AI</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>کاربر</th>
                                <th>تاریخ Opt-in</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($opt_in_users as $user): ?>
                            <tr>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $user['id']; ?>">
                                        <?php echo h($user['full_name'] ?? $user['email']); ?>
                                    </a>
                                </td>
                                <td><?php echo formatDate($user['ai_opt_in_date']); ?></td>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $user['id']; ?>" class="btn btn-xs btn-info">
                                        <i class="material-icons">visibility</i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($opt_in_users)): ?>
                            <tr>
                                <td colspan="3" class="text-center text-muted">هیچ کاربری یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- درخواست‌های حذف -->
    <div class="col-lg-6">
        <div class="card">
            <div class="header">
                <h2>درخواست‌های حذف داده</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>کاربر</th>
                                <th>تاریخ درخواست</th>
                                <th>وضعیت</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($deletion_requests as $request): ?>
                            <tr>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $request['user_id']; ?>">
                                        <?php echo h($request['full_name'] ?? $request['email']); ?>
                                    </a>
                                </td>
                                <td><?php echo formatDate($request['created_at']); ?></td>
                                <td>
                                    <?php
                                    $status = $request['status'] ?? 'pending';
                                    $statusColors = [
                                        'pending' => 'bg-orange',
                                        'processing' => 'bg-blue',
                                        'completed' => 'bg-green',
                                        'failed' => 'bg-red'
                                    ];
                                    $statusLabels = [
                                        'pending' => 'در انتظار',
                                        'processing' => 'در حال پردازش',
                                        'completed' => 'انجام شده',
                                        'failed' => 'ناموفق'
                                    ];
                                    ?>
                                    <span class="badge <?php echo $statusColors[$status] ?? 'bg-grey'; ?>">
                                        <?php echo $statusLabels[$status] ?? $status; ?>
                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($deletion_requests)): ?>
                            <tr>
                                <td colspan="3" class="text-center text-muted">هیچ درخواستی یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
