<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'راه‌اندازی 2FA';
$db = Database::getInstance();
$session = Session::getInstance();
$auth = Auth::getInstance();

// فقط Super Admin می‌تواند به این صفحه دسترسی داشته باشد
if (!$auth->hasRole('super_admin')) {
    $session->setError('شما به این بخش دسترسی ندارید.');
    redirect('index.php');
}

// بررسی وجود اطلاعات 2FA در session
if (!isset($_SESSION['2fa_setup'])) {
    $session->setError('اطلاعات 2FA یافت نشد.');
    redirect('admins.php');
}

$setupData = $_SESSION['2fa_setup'];
$adminId = $setupData['admin_id'];
$secret = $setupData['secret'];
$backupCodes = $setupData['backup_codes'];

// دریافت اطلاعات ادمین
$admin = $db->fetchOne("
    SELECT a.*, u.email, u.full_name
    FROM admins a
    INNER JOIN users u ON a.user_id = u.id
    WHERE a.id = ?
", [$adminId]);

if (!$admin) {
    $session->setError('ادمین یافت نشد.');
    redirect('admins.php');
}

// تولید QR Code URL
require_once '../vendor/autoload.php';
$google2fa = new \PragmaRX\Google2FA\Google2FA();

$companyName = 'Ayeneh Admin';
$companyEmail = $admin['email'];

$qrCodeUrl = $google2fa->getQRCodeUrl(
    $companyName,
    $companyEmail,
    $secret
);

// پاک کردن session بعد از نمایش
if (isset($_GET['done'])) {
    unset($_SESSION['2fa_setup']);
    $session->setSuccess('2FA با موفقیت راه‌اندازی شد.');
    redirect('admins.php');
}

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="header bg-green">
                <h2 class="text-white">
                    <i class="material-icons">verified_user</i>
                    راه‌اندازی احراز هویت دو مرحله‌ای (2FA)
                </h2>
            </div>
            <div class="body">
                <div class="alert alert-success">
                    <strong>موفق!</strong> 2FA برای <strong><?php echo h($admin['full_name'] ?? $admin['email']); ?></strong> فعال شد.
                </div>

                <div class="row">
                    <!-- QR Code -->
                    <div class="col-md-6">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4><i class="material-icons">qr_code_2</i> مرحله 1: اسکن QR Code</h4>
                            </div>
                            <div class="panel-body text-center">
                                <p>با استفاده از برنامه <strong>Google Authenticator</strong> این QR Code را اسکن کنید:</p>

                                <!-- QR Code با استفاده از Google Charts API -->
                                <img src="https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=<?php echo urlencode($qrCodeUrl); ?>"
                                     alt="QR Code"
                                     style="border: 2px solid #ddd; padding: 10px; background: white;">

                                <div class="alert alert-info m-t-20">
                                    <strong>نکته:</strong> اگر نمی‌توانید QR Code را اسکن کنید، می‌توانید کد زیر را به صورت دستی وارد کنید:
                                    <br><br>
                                    <code style="font-size: 18px; background: #fff; padding: 10px; display: inline-block; border: 1px solid #ddd;">
                                        <?php echo chunk_split($secret, 4, ' '); ?>
                                    </code>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Backup Codes -->
                    <div class="col-md-6">
                        <div class="panel panel-warning">
                            <div class="panel-heading">
                                <h4><i class="material-icons">backup</i> مرحله 2: کدهای بازیابی</h4>
                            </div>
                            <div class="panel-body">
                                <div class="alert alert-warning">
                                    <i class="material-icons">warning</i>
                                    <strong>مهم!</strong> این کدها را در جای امنی ذخیره کنید. در صورت از دست دادن دسترسی به Google Authenticator، می‌توانید با این کدها وارد شوید.
                                </div>

                                <div style="background: #fff; padding: 20px; border: 2px dashed #f0ad4e; border-radius: 5px;">
                                    <h5 style="margin-top: 0;">کدهای بازیابی:</h5>
                                    <ul class="list-unstyled" style="font-family: monospace; font-size: 16px; line-height: 2;">
                                        <?php foreach ($backupCodes as $code): ?>
                                        <li>
                                            <i class="material-icons" style="font-size: 16px; color: #f0ad4e;">vpn_key</i>
                                            <strong><?php echo chunk_split($code, 4, '-'); ?></strong>
                                        </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>

                                <button class="btn btn-info btn-block m-t-15" onclick="printBackupCodes()">
                                    <i class="material-icons">print</i>
                                    چاپ کدهای بازیابی
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- دستورالعمل -->
                <div class="alert alert-info">
                    <h4><i class="material-icons">info</i> دستورالعمل استفاده</h4>
                    <ol>
                        <li>برنامه <strong>Google Authenticator</strong> را از App Store یا Google Play دانلود کنید.</li>
                        <li>QR Code بالا را با برنامه اسکن کنید (یا کد را به صورت دستی وارد کنید).</li>
                        <li>کدهای بازیابی را در جای امنی ذخیره کنید.</li>
                        <li>از این پس، هنگام ورود به پنل مدیریت، علاوه بر رمز عبور، باید کد 6 رقمی از Google Authenticator را نیز وارد کنید.</li>
                    </ol>
                </div>

                <div class="text-center m-t-30">
                    <a href="admin_2fa_setup.php?id=<?php echo $adminId; ?>&done=1" class="btn btn-success btn-lg waves-effect">
                        <i class="material-icons">check_circle</i>
                        تمام شد - بازگشت به لیست مدیران
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function printBackupCodes() {
    let codes = <?php echo json_encode($backupCodes); ?>;
    let printWindow = window.open('', '', 'height=600,width=800');

    printWindow.document.write('<html><head><title>کدهای بازیابی 2FA</title>');
    printWindow.document.write('<style>body { font-family: Arial; padding: 40px; } h2 { color: #333; } ul { list-style: none; padding: 0; } li { padding: 10px; margin: 5px 0; background: #f9f9f9; border: 1px solid #ddd; font-family: monospace; font-size: 18px; }</style>');
    printWindow.document.write('</head><body dir="rtl">');
    printWindow.document.write('<h2>کدهای بازیابی 2FA - <?php echo h($admin['full_name'] ?? $admin['email']); ?></h2>');
    printWindow.document.write('<p><strong>تاریخ ایجاد:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>');
    printWindow.document.write('<p style="color: red;"><strong>هشدار:</strong> این کدها را در جای امنی نگه دارید!</p>');
    printWindow.document.write('<ul>');

    codes.forEach(function(code) {
        printWindow.document.write('<li>' + code.match(/.{1,4}/g).join('-') + '</li>');
    });

    printWindow.document.write('</ul>');
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.print();
}
</script>

<?php include 'php/includes/footer.php'; ?>
